//Listing 16.11. Wykorzystanie klasy Matrix z przecionym operatorem wywoania funkcji
#include <iostream>
#include <iomanip>
using namespace std;

class Matrix {
  int *cells; // tablica na stercie zawierajca macierz
  int size; // liczba wierszy i kolumn
  int* make(int size) // prywatny alokator
  { int* p = new int [size * size]; // cakowita liczba elementw
  if (p == NULL) { cout << "Macierz zbyt dua\n"; exit(0); }
  return p; } // zwr wskanik do obszaru na stercie
public:
  Matrix (int sz) : size(sz) // konstruktor konwertujcy
  { cells = make(size); } // pami na stercie nie jest zainicjalizowana
  Matrix (const Matrix& m) : size(m.size)
  { cells = make(size); } // konstruktor kopiujcy: dla bezpieczestwa
  Matrix& operator = (const Matrix& m); // operator przypisania
  int getSize() const // rozmiar
  { return size; }
  int& operator () (int r, int c) const; // pobierz lub zmodyfikuj element
  ~Matrix() { delete [] cells; } // destruktor
} ;

Matrix& Matrix::operator = (const Matrix& m) // przypisanie
{ if (this == &m) return *this; // brak operacji jeli przypisanie do tego samego obiektu
  delete [ ] cells; // zwolnij istniejc pami
  cells = make(m.size); // przydziel (ustaw) nowy obszar pamici
  size = m.size; // ustaw rozmiar macierzy
  for (int i=0; i<size*size; i++) // skopiuj dane
    cells[i] = m.cells[i];
  return *this; } // w celu obsugi przypisywania w acuchu

int& Matrix::operator () (int r, int c) const
{ if (r<0 || c<0 || r>=size || c>=size) // sprawd poprawno
  return cells[size*size-1]; // zwr ostatni komrk macierzy
  return cells[r*size + c]; } // zwr dan komrk

void printMatrix(const Matrix& m) // funkcja klienta
{ int size = m.getSize();
  for (int i=0; i < size; i++) // przeszukaj kady wiersz
  { for (int j=0; j < size; j++) // oraz kolumn
      cout << setw(4) << m(i,j); // wywietl komrk
    cout << endl; } // oraz biecy wiersz
   cout << endl; } // koniec macierzy

int main()
{ cout << endl << endl;
  int i, j, n = 5; Matrix m1(n); // obiekt klasy Matrix
  for (i=0; i < n; i++)
    for (j=0; j < n; j++) // zainicjalizuj komrki
      m1(i,j) = (i+1) * (j+1); // m1[i][j] = (i+1)*(j+1);
  printMatrix(m1); // wywietl stan macierzy
  for (i=0; i < n; i++) // umie zera na przektnej
    m1(i,i) = 0; // m1[i][i] = 0
  printMatrix(m1); // wywietl nowy stan
  cout << "m[10][10] = " << m1(10,10) << endl; // zakres zosta przekroczony
  return 0;
}
